function MSEdB = sim_fov(T,L,K,f_cfo_max,samples,SNRdB_set)
    bg_process = parfeval(gcp, @py_fov_mse, 1, T, L, K, f_cfo_max, samples, SNRdB_set);
    MSEdB = fetchOutputs(bg_process);
    disp(MSEdB)
end

function MSEdB = py_fov_mse(T,L,K,f_cfo_max,samples,SNRdB_set)
    % pythonExe = "C:\Users\IT  CITY\AppData\Local\Programs\Python\Python310\python.exe";
    % setenv('TCL_LIBRARY', ...
    %     'C:\Users\IT  CITY\AppData\Local\Programs\Python\Python310\tcl\tcl8.6');
    pythonExe = "C:\HKUST\Project\.venv\Scripts\python.exe";
    env = pyenv;
    if strcmp(env.Status, 'Loaded')
    else
        pyenv('Version', pythonExe);
    end

    fov_mse = py.importlib.import_module("fov_mse_vs_snr");
    py.importlib.reload(fov_mse);
    MSEdB_np = fov_mse.main(T,L,K,f_cfo_max,samples,py.list(SNRdB_set));
    MSEdB = transpose(double(MSEdB_np));
end